/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.framework.msdf;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.framework.msdf.Font;
import Krasnodar.rockstarnew.framework.msdf.FontData;
import Krasnodar.rockstarnew.framework.msdf.MsdfGlyph;
import Krasnodar.rockstarnew.framework.msdf.ResourceProvider;
import Krasnodar.rockstarnew.systems.modules.modules.other.NameProtect;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import org.joml.Matrix4f;

public final class MsdfFont {
    private final String name;
    private final class_1044 texture;
    private final FontData.AtlasData atlas;
    private final FontData.MetricsData metrics;
    private final Map<Integer, MsdfGlyph> glyphs;
    private final Map<Integer, Map<Integer, Float>> kernings;
    private final ConcurrentHashMap<Long, Float> widthCache = new ConcurrentHashMap();

    private MsdfFont(String name, class_1044 texture, FontData.AtlasData atlas, FontData.MetricsData metrics, Map<Integer, MsdfGlyph> glyphs, Map<Integer, Map<Integer, Float>> kernings) {
        this.name = name;
        this.texture = texture;
        this.atlas = atlas;
        this.metrics = metrics;
        this.glyphs = glyphs;
        this.kernings = kernings;
    }

    public int getTextureId() {
        return this.texture.method_4624();
    }

    public void applyGlyphs(Matrix4f matrix, class_4588 consumer, String text, float size, float thickness, float spacing, float x, float y, float z, int color) {
        int prevChar = -1;
        boolean skipNext = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (skipNext) {
                skipNext = false;
                continue;
            }
            if (c == '\u00a7') {
                skipNext = true;
                continue;
            }
            MsdfGlyph glyph = this.glyphs.get(c);
            if (glyph == null) continue;
            Map<Integer, Float> kerning = this.kernings.get(prevChar);
            if (kerning != null) {
                x += kerning.getOrDefault(c, Float.valueOf(0.0f)).floatValue() * size;
            }
            x += glyph.apply(matrix, consumer, size, x, y, z, color) + thickness + spacing;
            prevChar = c;
        }
    }

    public float getWidthOld(String text, float size) {
        text = text.replace("\u0456", "i").replace("\u0406", "I");
        int prevChar = -1;
        float width = 0.0f;
        boolean skipNext = false;
        NameProtect nameProtectModule = Rockstar.getInstance().getModuleManager().getModule(NameProtect.class);
        if (nameProtectModule.isEnabled()) {
            text = nameProtectModule.patchName(text);
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (skipNext) {
                skipNext = false;
                continue;
            }
            if (c == '\u00a7') {
                skipNext = true;
                continue;
            }
            MsdfGlyph glyph = this.glyphs.get(c);
            if (glyph == null) continue;
            Map<Integer, Float> kerning = this.kernings.get(prevChar);
            if (kerning != null) {
                width += kerning.getOrDefault(c, Float.valueOf(0.0f)).floatValue() * size;
            }
            width += glyph.getWidth(size) + 0.25f;
            prevChar = c;
        }
        return width;
    }

    private static long widthKey(String s, float size, boolean np) {
        int h = s.hashCode();
        return (long)h & 0xFFFFFFFFL ^ (long)Float.floatToIntBits(size) << 32 ^ (np ? -7046029254386353131L : 0L);
    }

    public float getWidth(String text, float size) {
        long key;
        Float cached;
        text = text.replace("\u0456", "i").replace("\u0406", "I");
        NameProtect nameProtectModule = Rockstar.getInstance().getModuleManager().getModule(NameProtect.class);
        boolean np = nameProtectModule.isEnabled();
        if (np) {
            text = nameProtectModule.patchName(text);
        }
        if ((cached = this.widthCache.get(key = MsdfFont.widthKey(text, size, np))) != null) {
            return cached.floatValue();
        }
        float w = this.getWidthOld(text, size);
        this.widthCache.put(key, Float.valueOf(w));
        return w;
    }

    public void clearWidthCache() {
        this.widthCache.clear();
    }

    public float getTextWidth(class_2561 text, float size) {
        return this.getWidth(text.getString(), size);
    }

    public Font getFont(float size) {
        return new Font(this, size);
    }

    public String getName() {
        return this.name;
    }

    public FontData.AtlasData getAtlas() {
        return this.atlas;
    }

    public FontData.MetricsData getMetrics() {
        return this.metrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name = "?";
        private class_2960 dataIdentifer;
        private class_2960 atlasIdentifier;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder data(String dataFileName) {
            this.dataIdentifer = class_2960.method_60655((String)"rockstarnew", (String)("fonts/msdf/" + dataFileName + ".json"));
            return this;
        }

        public Builder atlas(String atlasFileName) {
            this.atlasIdentifier = class_2960.method_60655((String)"rockstarnew", (String)("fonts/msdf/" + atlasFileName + ".png"));
            return this;
        }

        public MsdfFont build() {
            FontData data = ResourceProvider.fromJsonToInstance(this.dataIdentifer, FontData.class);
            class_1044 texture = class_310.method_1551().method_1531().method_4619(this.atlasIdentifier);
            if (data == null) {
                throw new RuntimeException("Failed to read font data file: " + this.dataIdentifer.toString() + "; Are you sure this is json file? Try to check the correctness of its syntax.");
            }
            RenderSystem.recordRenderCall(() -> texture.method_4527(true, false));
            float aWidth = data.atlas().width();
            float aHeight = data.atlas().height();
            Map<Integer, MsdfGlyph> glyphs = data.glyphs().stream().collect(Collectors.toMap(glyphData -> glyphData.unicode(), glyphData -> new MsdfGlyph((FontData.GlyphData)glyphData, aWidth, aHeight)));
            HashMap<Integer, Map<Integer, Float>> kernings = new HashMap<Integer, Map<Integer, Float>>();
            data.kernings().forEach(kerning -> {
                HashMap<Integer, Float> map = (HashMap<Integer, Float>)kernings.get(kerning.leftChar());
                if (map == null) {
                    map = new HashMap<Integer, Float>();
                    kernings.put(kerning.leftChar(), map);
                }
                map.put(kerning.rightChar(), Float.valueOf(kerning.advance()));
            });
            return new MsdfFont(this.name, texture, data.atlas(), data.metrics(), glyphs, kernings);
        }
    }
}

